using System;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;

using gov.va.med.vbecs.BOL;

namespace gov.va.med.vbecs.GUI.controls
{
	/// <summary>
	/// Base dialog for all reports criteria dialogs. Contains 2 panels that may be
	/// used by derived dialogs (see 'protected' panels). Both panels can be made 
	/// invisible by derived dialogs.
	/// 
	/// Child dialogs are expected to set an appropriate report logo image
	/// accessible via <see cref="ReportLogo"/> property.
	/// </summary>	
	public 
#if !DESIGN // Making class not abstract in DESIGN configuration allows editing the form (and derived forms ;) in VS.NET designer
		abstract 		
#endif
		class DlgBaseVbecsReportCriteria : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		private const int ReportPageCountWarningThreshold = 50;

		private VbecsReport _report;

		/// <summary>
		/// pnlMiddleLeftDescArea
		/// </summary>
		protected System.Windows.Forms.Panel pnlMiddleLeftDescArea;

		/// <summary>
		/// pnlBasePrimaryDescArea
		/// </summary>
		protected System.Windows.Forms.Panel pnlBasePrimaryDescArea;

		private System.Windows.Forms.Panel pnlBottomButtonBar;
		private System.Windows.Forms.Panel pnlLeftLogoBar;
		private System.Windows.Forms.Panel pnlReportCompilation;
		private System.Windows.Forms.Panel pnlPrimarySurface;
		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.GroupBox grpReportCompilation;
		private System.Windows.Forms.RadioButton rdoScheduleJob;
		private System.Windows.Forms.RadioButton rdoCreateNow;
		private System.Windows.Forms.GroupBox grpScheduleJob;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbPrinterName;
		private System.Windows.Forms.Label lblPrinterName;
		private System.Windows.Forms.Label lblPrintDate;
		private System.Windows.Forms.DateTimePicker dtpPrintDate;
		private System.Windows.Forms.PictureBox picReportLogo;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private System.Windows.Forms.Button btnCancel;
		private System.ComponentModel.IContainer components = null;

		/// <summary>
		/// Constructor
		/// </summary>
		public DlgBaseVbecsReportCriteria()
		{			
			this.DialogResult = DialogResult.Cancel;

			InitializeControls();
			SetComponentProperties();
			AttachEventHandlers();			
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			this.pnlPrimarySurface = new System.Windows.Forms.Panel();
			this.pnlBasePrimaryDescArea = new System.Windows.Forms.Panel();
			this.pnlReportCompilation = new System.Windows.Forms.Panel();
			this.grpReportCompilation = new System.Windows.Forms.GroupBox();
			this.rdoScheduleJob = new System.Windows.Forms.RadioButton();
			this.rdoCreateNow = new System.Windows.Forms.RadioButton();
			this.grpScheduleJob = new System.Windows.Forms.GroupBox();
			this.cmbPrinterName = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.lblPrinterName = new System.Windows.Forms.Label();
			this.lblPrintDate = new System.Windows.Forms.Label();
			this.dtpPrintDate = new System.Windows.Forms.DateTimePicker();
			this.pnlMiddleLeftDescArea = new System.Windows.Forms.Panel();
			this.pnlLeftLogoBar = new System.Windows.Forms.Panel();
			this.grpImage = new System.Windows.Forms.GroupBox();
			this.picReportLogo = new System.Windows.Forms.PictureBox();
			this.pnlBottomButtonBar = new System.Windows.Forms.Panel();
			this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.btnCancel = new System.Windows.Forms.Button();
			this.pnlPrimarySurface.SuspendLayout();
			this.pnlReportCompilation.SuspendLayout();
			this.grpReportCompilation.SuspendLayout();
			this.grpScheduleJob.SuspendLayout();
			this.pnlLeftLogoBar.SuspendLayout();
			this.grpImage.SuspendLayout();
			this.pnlBottomButtonBar.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(384, 30);
			this.vbecsLogo1.Title = "[Specify Report Name]";
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 227);
			this.lblRequiredField.Name = "lblRequiredField";
			// 
			// pnlPrimarySurface
			// 
			this.pnlPrimarySurface.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.pnlPrimarySurface.Controls.Add(this.pnlBasePrimaryDescArea);
			this.pnlPrimarySurface.Controls.Add(this.pnlReportCompilation);
			this.pnlPrimarySurface.Controls.Add(this.pnlMiddleLeftDescArea);
			this.pnlPrimarySurface.Controls.Add(this.pnlLeftLogoBar);
			this.pnlPrimarySurface.Controls.Add(this.pnlBottomButtonBar);
			this.pnlPrimarySurface.Location = new System.Drawing.Point(0, 30);
			this.pnlPrimarySurface.Name = "pnlPrimarySurface";
			this.pnlPrimarySurface.Size = new System.Drawing.Size(384, 213);
			this.pnlPrimarySurface.TabIndex = 3;
			// 
			// pnlBasePrimaryDescArea
			// 
			this.pnlBasePrimaryDescArea.Dock = System.Windows.Forms.DockStyle.Fill;
			this.pnlBasePrimaryDescArea.Location = new System.Drawing.Point(96, 0);
			this.pnlBasePrimaryDescArea.Name = "pnlBasePrimaryDescArea";
			this.pnlBasePrimaryDescArea.Size = new System.Drawing.Size(288, 47);
			this.pnlBasePrimaryDescArea.TabIndex = 4;
			// 
			// pnlReportCompilation
			// 
			this.pnlReportCompilation.Controls.Add(this.grpReportCompilation);
			this.pnlReportCompilation.Dock = System.Windows.Forms.DockStyle.Bottom;
			this.pnlReportCompilation.Location = new System.Drawing.Point(96, 47);
			this.pnlReportCompilation.Name = "pnlReportCompilation";
			this.pnlReportCompilation.Size = new System.Drawing.Size(288, 136);
			this.pnlReportCompilation.TabIndex = 3;
			// 
			// grpReportCompilation
			// 
			this.grpReportCompilation.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpReportCompilation.Controls.Add(this.rdoScheduleJob);
			this.grpReportCompilation.Controls.Add(this.rdoCreateNow);
			this.grpReportCompilation.Controls.Add(this.grpScheduleJob);
			this.grpReportCompilation.Location = new System.Drawing.Point(0, 0);
			this.grpReportCompilation.Name = "grpReportCompilation";
			this.grpReportCompilation.Size = new System.Drawing.Size(284, 132);
			this.grpReportCompilation.TabIndex = 31;
			this.grpReportCompilation.TabStop = false;
			this.grpReportCompilation.Text = "Report Compilation*";
			// 
			// rdoScheduleJob
			// 
			this.rdoScheduleJob.Location = new System.Drawing.Point(16, 44);
			this.rdoScheduleJob.Name = "rdoScheduleJob";
			this.rdoScheduleJob.Size = new System.Drawing.Size(120, 16);
			this.rdoScheduleJob.TabIndex = 1;
			this.rdoScheduleJob.Text = "&Schedule Print Job";
			// 
			// rdoCreateNow
			// 
			this.rdoCreateNow.Checked = true;
			this.rdoCreateNow.Location = new System.Drawing.Point(16, 20);
			this.rdoCreateNow.Name = "rdoCreateNow";
			this.rdoCreateNow.Size = new System.Drawing.Size(124, 16);
			this.rdoCreateNow.TabIndex = 0;
			this.rdoCreateNow.TabStop = true;
			this.rdoCreateNow.Text = "Create Report &Now";
			// 
			// grpScheduleJob
			// 
			this.grpScheduleJob.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpScheduleJob.Controls.Add(this.cmbPrinterName);
			this.grpScheduleJob.Controls.Add(this.lblPrinterName);
			this.grpScheduleJob.Controls.Add(this.lblPrintDate);
			this.grpScheduleJob.Controls.Add(this.dtpPrintDate);
			this.grpScheduleJob.Enabled = false;
			this.grpScheduleJob.Location = new System.Drawing.Point(8, 44);
			this.grpScheduleJob.Name = "grpScheduleJob";
			this.grpScheduleJob.Size = new System.Drawing.Size(268, 80);
			this.grpScheduleJob.TabIndex = 2;
			this.grpScheduleJob.TabStop = false;
			this.grpScheduleJob.Text = "grpScheduleJob";
			// 
			// cmbPrinterName
			// 
			this.cmbPrinterName.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cmbPrinterName.Interval = 500;
			this.cmbPrinterName.Location = new System.Drawing.Point(96, 44);
			this.cmbPrinterName.Name = "cmbPrinterName";
			this.cmbPrinterName.Size = new System.Drawing.Size(164, 22);
			this.cmbPrinterName.TabIndex = 14;
			this.cmbPrinterName.SelectedIndexChanged += new System.EventHandler(this.PrinterNameChanged);
			// 
			// lblPrinterName
			// 
			this.lblPrinterName.Location = new System.Drawing.Point(24, 44);
			this.lblPrinterName.Name = "lblPrinterName";
			this.lblPrinterName.Size = new System.Drawing.Size(76, 20);
			this.lblPrinterName.TabIndex = 13;
			this.lblPrinterName.Text = "Printer Name*";
			this.lblPrinterName.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblPrintDate
			// 
			this.lblPrintDate.Location = new System.Drawing.Point(24, 20);
			this.lblPrintDate.Name = "lblPrintDate";
			this.lblPrintDate.Size = new System.Drawing.Size(72, 20);
			this.lblPrintDate.TabIndex = 11;
			this.lblPrintDate.Text = "Print Date*";
			this.lblPrintDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// dtpPrintDate
			// 
			this.dtpPrintDate.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.dtpPrintDate.CalendarFont = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dtpPrintDate.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.dtpPrintDate.Location = new System.Drawing.Point(96, 20);
			this.dtpPrintDate.Name = "dtpPrintDate";
			this.dtpPrintDate.Size = new System.Drawing.Size(164, 20);
			this.dtpPrintDate.TabIndex = 12;
			this.dtpPrintDate.Value = new System.DateTime(2003, 6, 20, 15, 24, 4, 467);
			// 
			// pnlMiddleLeftDescArea
			// 
			this.pnlMiddleLeftDescArea.Dock = System.Windows.Forms.DockStyle.Left;
			this.pnlMiddleLeftDescArea.Location = new System.Drawing.Point(60, 0);
			this.pnlMiddleLeftDescArea.Name = "pnlMiddleLeftDescArea";
			this.pnlMiddleLeftDescArea.Size = new System.Drawing.Size(36, 183);
			this.pnlMiddleLeftDescArea.TabIndex = 2;
			// 
			// pnlLeftLogoBar
			// 
			this.pnlLeftLogoBar.Controls.Add(this.grpImage);
			this.pnlLeftLogoBar.Dock = System.Windows.Forms.DockStyle.Left;
			this.pnlLeftLogoBar.Location = new System.Drawing.Point(0, 0);
			this.pnlLeftLogoBar.Name = "pnlLeftLogoBar";
			this.pnlLeftLogoBar.Size = new System.Drawing.Size(60, 183);
			this.pnlLeftLogoBar.TabIndex = 1;
			// 
			// grpImage
			// 
			this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpImage.Controls.Add(this.picReportLogo);
			this.grpImage.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.grpImage.Location = new System.Drawing.Point(4, 0);
			this.grpImage.Name = "grpImage";
			this.grpImage.Size = new System.Drawing.Size(52, 179);
			this.grpImage.TabIndex = 25;
			this.grpImage.TabStop = false;
			// 
			// picReportLogo
			// 
			this.picReportLogo.Font = new System.Drawing.Font("Microsoft Sans Serif", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.picReportLogo.Location = new System.Drawing.Point(4, 12);
			this.picReportLogo.Name = "picReportLogo";
			this.picReportLogo.Size = new System.Drawing.Size(45, 45);
			this.picReportLogo.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.picReportLogo.TabIndex = 0;
			this.picReportLogo.TabStop = false;
			// 
			// pnlBottomButtonBar
			// 
			this.pnlBottomButtonBar.Controls.Add(this.btnOK);
			this.pnlBottomButtonBar.Controls.Add(this.btnCancel);
			this.pnlBottomButtonBar.Dock = System.Windows.Forms.DockStyle.Bottom;
			this.pnlBottomButtonBar.Location = new System.Drawing.Point(0, 183);
			this.pnlBottomButtonBar.Name = "pnlBottomButtonBar";
			this.pnlBottomButtonBar.Size = new System.Drawing.Size(384, 30);
			this.pnlBottomButtonBar.TabIndex = 0;
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnOK.Image = null;
			this.btnOK.Location = new System.Drawing.Point(224, 2);
			this.btnOK.Name = "btnOK";
			this.btnOK.Size = new System.Drawing.Size(75, 23);
			this.btnOK.TabIndex = 30;
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.CausesValidation = false;
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnCancel.Location = new System.Drawing.Point(305, 2);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 29;
			this.btnCancel.Text = "&Cancel";
			// 
			// DlgBaseVbecsReportCriteria
			// 
			this.AcceptButton = this.btnOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(384, 243);
			this.Controls.Add(this.pnlPrimarySurface);
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MinimumSize = new System.Drawing.Size(392, 270);
			this.Name = "DlgBaseVbecsReportCriteria";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - [Specify Report Dialog Title]";
			this.Controls.SetChildIndex(this.pnlPrimarySurface, 0);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.pnlPrimarySurface.ResumeLayout(false);
			this.pnlReportCompilation.ResumeLayout(false);
			this.grpReportCompilation.ResumeLayout(false);
			this.grpScheduleJob.ResumeLayout(false);
			this.pnlLeftLogoBar.ResumeLayout(false);
			this.grpImage.ResumeLayout(false);
			this.pnlBottomButtonBar.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// Initializes form controls calling code generated by WinForms designer. 
		/// Override this method in derived forms if you're overriding <see cref="SetComponentProperties"/>.
		/// </summary>
		protected virtual void InitializeControls()
		{
			InitializeComponent();
		}

		/// <summary>
		/// Sets properties for controls and inner objects. Called from constructor. 
		/// If you override this method and refer to on-form controls from it, you 
		/// MUST override <see cref="InitializeControls"/> method to initialize controls 
		/// on the form.
		/// </summary>
		protected virtual void SetComponentProperties()
		{			
#if !DESIGN
			_report = GetReportObject();
			dtpPrintDate.CustomFormat = Common.VBECSDateTime.DateTimeFormat;
			dtpPrintDate.Value = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
			this.SetThisToolTip( btnCancel, Common.StrRes.Tooltips.Common.Cancel() );
#endif

			LoadPrintersComboBox();
		}

		/// <summary>
		/// Attaches event handlers to on-form controls. Called after form controls has been initialized, so 
		/// no need to check in event handlers if data is being loaded. Override this method if you're adding 
		/// custom controls requiring event handlers. 
		/// </summary>
		protected virtual void AttachEventHandlers()
		{
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
			this.rdoCreateNow.CheckedChanged += new System.EventHandler(this.ReportCompilationChanged);
			this.rdoScheduleJob.CheckedChanged += new System.EventHandler(this.ReportCompilationChanged);
			this.cmbPrinterName.SelectedIndexChanged += new System.EventHandler(this.PrinterNameChanged);
			this.dtpPrintDate.ValueChanged += new System.EventHandler(this.PrintDateChanged);

			this.Load += new EventHandler(DlgBaseVbecsReportCriteria_Load);
		}

		private void DlgBaseVbecsReportCriteria_Load(object sender, EventArgs e)
		{
#if !DESIGN
			OnDialogControlChanged();
#endif
			if( btnOK.CanFocus )
				btnOK.Focus();
		}

		private void LoadPrintersComboBox()
		{
			this.cmbPrinterName.Items.Clear();

			foreach( string _printerName in BOL.VbecsReport.GetPrinters() )
				cmbPrinterName.Items.Add( _printerName );
		}

		/// <summary>
		/// Should be called whenever any dialog control is changed to update state of OK button. 
		/// Call it from derived event handlers when needed.
		/// </summary>
		protected virtual void OnDialogControlChanged()
		{
			btnOK.EnabledButton = _report.IsValid;
			btnOK.SetToolTip( _report.IsValid ? Common.StrRes.Tooltips.Common.OKToContinue().ResString : GetValidationMessage() );
		}

		private void ReportCompilationChanged( object sender, System.EventArgs e)
		{
			_report.IsScheduled = grpScheduleJob.Enabled = rdoScheduleJob.Checked;

			if( _report.IsScheduled && _report.PrintDate == DateTime.MinValue )
				this.dtpPrintDate.Value = BOL.VBECSDateTime.GetDivisionCurrentDateTime().AddDays( 1 );

			OnDialogControlChanged();
		}

		private void PrintDateChanged(object sender, System.EventArgs e)
		{
			if( _report.IsScheduled )
				_report.PrintDate = this.dtpPrintDate.Value;

			OnDialogControlChanged();
		}

		private void PrinterNameChanged(object sender, System.EventArgs e)
		{
			if( !_report.IsScheduled )
				return;

			if(cmbPrinterName.SelectedItem!=null)
			{
				string printer=this.cmbPrinterName.Text;
				for(int i=0; i<this.cmbPrinterName.Items.Count; i++)
				{
					if(printer==this.cmbPrinterName.Items[i].ToString())
					{
						this._report.PrinterName = cmbPrinterName.SelectedItem.ToString();
					}
				}
			}		
			else
			{
				this._report.PrinterName=String.Empty;
			}

			//_report.PrinterName = ( this.cmbPrinterName.SelectedIndex > -1 ) ? this.cmbPrinterName.Text : String.Empty;

			OnDialogControlChanged();
		}

		/// <summary>
		/// This method is called in constructor to create corresponding report object. 
		/// Derived dialogs must override this method to return new instance of report-specific class. 
		/// </summary>
		/// <returns>New instance of correponding report class.</returns>
		protected 
#if !DESIGN 
		abstract VbecsReport GetReportObject();
#else
		virtual VbecsReport GetReportObject() 
		{ 
			return null; // Stub value 
		}
#endif			

		/// <summary>
		/// Retrieves validation message (simple combined broken rules message will be sufficient).
		/// </summary>
		/// <returns>String validation message.</returns>
		protected 
#if !DESIGN 
		abstract string GetValidationMessage();
#else
		virtual string GetValidationMessage()
		{
			return null; // Stub value 
		}
#endif

		/// <summary>
		/// Returns estimated report records count.
		/// </summary>
		protected 
#if !DESIGN 
		abstract int GetReportRecordCountEstimate();
#else
		virtual int GetReportRecordCountEstimate()
		{
			return 0; // Stub value 
		}
#endif

		/// <summary>
		/// Specifies number of report records per page.
		/// </summary>
		protected 
#if !DESIGN 
		abstract int NumberOfRecordsPerReportPage
		{
			get;
		}
#else
		virtual int NumberOfRecordsPerReportPage
		{
			get
			{
				return -1; // Stub value 
			}
		}
#endif

		/// <summary>
		/// Override this method to check additional business rules / confirmations not handled 
		/// by broken rules in your report object.
		/// Make sure you call base implementation from yours - checks like 'scheduled report's date 
		/// range is greater than 30 days' and so on are done here.
		/// </summary>
		/// <returns>True if everything is valid and user confirmed everything.</returns>
		protected virtual bool CheckAdditionalBusinessRules()
		{
			return CheckWarnAboutThirtyDaysScheduling() && RunReportRecordCountBasedChecks();
		}

		/// <summary>
		/// If report date range exceeds 30 days for scheduled report, the method asks user confirmation
		/// and returns false if user declines to proceed. Override this method to always return true if 
		/// you want to disable the check. 
		/// </summary>
		/// <returns>True if user confirms the choice, false otherwise.</returns>
		protected virtual bool CheckWarnAboutThirtyDaysScheduling()
		{
			return 
				!this.InnerReport.IsScheduledReportGreaterThanThirtyDays ||
				DialogResult.Yes == GuiMessenger.ShowMessageBox( Common.StrRes.ConfMsg.Common.ScheduledReportGreaterThanThirtyDays() );				
		}

		/// <summary>
		/// Performs record-count based checks( 'scheduled report's date range is greater than 30 days' et cetera).
		/// Override this method to return true if you want to disable the checks. 
		/// </summary>
		/// <returns>True if all record count based checks are OK.</returns>
		protected virtual bool RunReportRecordCountBasedChecks()
		{
			//Don't perform checks if scheduled
			if (this.InnerReport.IsScheduled)
				return true;

			int _reportRecordCount;

			using( new WaitCursor() )
				_reportRecordCount = GetReportRecordCountEstimate();

			return
				CheckWarnAboutZeroRecordsReturned( _reportRecordCount ) &&
				CheckWarnAboutHeavyPageCount( _reportRecordCount ) && 
				CheckWarnAboutExtendedRecordCountBasedChecks( _reportRecordCount );
		}

		/// <summary>
		/// Does not do anything in base implementation, override it to perform extended record count based checks.
		/// </summary>
		/// <param name="recordsCount">
		///		Records count. Put here so the caller that needs to run other checks 
		///		against the record count won't have to calculate it twice.
		///	</param>
		/// <returns>Always returns true.</returns>
		protected virtual bool CheckWarnAboutExtendedRecordCountBasedChecks( int recordsCount )
		{
			return true;
		}

		/// <summary>
		/// If report record count is not positive, displays 'no data found' message to 
		/// user and returns false (therefore cancelling further processing). 
		/// Override this method to always return true if you need to disable the check.
		/// </summary>
		/// <param name="recordsCount">
		///		Records count. Put here so the caller that needs to run other checks 
		///		against the record count won't have to calculate it twice.
		///	</param>
		/// <returns>False if records count is zero. True otherwise.</returns>
		protected virtual bool CheckWarnAboutZeroRecordsReturned( int recordsCount )
		{
			if( recordsCount > 0 )
				return true;

			GuiMessenger.ShowMessageBox( Common.StrRes.InfoMsg.UC049.NoInfoReturned() );
			return false;
		}

		/// <summary>
		/// Checks if page count exceeds the threshold. If it does, user is asked to confirm his/her 
		/// choice of report criteria. If the user elects to proceed, the warning message is displayed
		/// saying that building a report may take a few minutes. 
		/// Override this method to always return true if you want to disable the check.
		/// </summary>
		/// <param name="recordsCount">
		///		Records count. Put here so the caller that needs to run other checks 
		///		against the record count won't have to calculate it twice.
		///	</param>
		/// <returns>False if record count exceeds the threshold and user cancelled the processing.</returns>
		protected virtual bool CheckWarnAboutHeavyPageCount( int recordsCount )
		{
			if( recordsCount / NumberOfRecordsPerReportPage < ReportPageCountWarningThreshold )
				return true;

			if( DialogResult.Yes != GuiMessenger.ShowMessageBox( Common.StrRes.ConfMsg.UC049.PageCountAlert() ) )
				return false;

			// Alert user that building report may take a few minutes
			GuiMessenger.ShowMessageBox( Common.StrRes.InfoMsg.UC049.Warning() );
			return true;
		}

		/// <summary>
		/// Override this method in derived dialogs to display additional messages 
		/// before the dialog is closed (button OK clicked). 
		/// </summary>
		protected virtual void ShowAdditionalMessages()
		{
		}

		private void btnOK_Click(object sender, System.EventArgs e)
		{
			if( !CheckAdditionalBusinessRules() )
				return;

			ShowAdditionalMessages();

			this.DialogResult = DialogResult.OK;
			this.Close();
		}

		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.DialogResult = DialogResult.Cancel;
			this.Close();
		}

		/// <summary>
		/// Report dialog image logo. Set it in designer for derived dialogs.
		/// </summary>
		[
		Category("VBECS Misc"),
		Description("VBECS Report Logo"),
		Bindable(false),
		Browsable(true)
		]
		public Image ReportLogo
		{
			get
			{
				return picReportLogo.Image;
			}
			set
			{
				picReportLogo.Image = value;
			}
		}

		/// <summary>
		/// Returns reference to dialog-incorporated report object. You might want to add custom 
		/// property casting report object to needed type.
		/// </summary>
		protected VbecsReport InnerReport
		{
			get
			{
				return _report;
			}
		}
	}
}

